<?php

namespace IQDEV\ElasticSearchTests\Helpers;

use IQDEV\ElasticSearch\Configuration;
use IQDEV\ElasticSearch\Document\ProductDocument;
use IQDEV\ElasticSearch\Document\Property\Property;
use IQDEV\ElasticSearch\Document\Property\PropertyType;
use IQDEV\ElasticSearch\Facet\FacetFactory;
use IQDEV\ElasticSearch\Indexer\AddIndex;
use IQDEV\ElasticSearch\Indexer\DeleteIndex;
use IQDEV\ElasticSearch\Indexer\IndexProvider;
use IQDEV\ElasticSearch\Indexer\UpdateIndex;

class TestIndexProvider implements IndexProvider
{

    private Configuration $configuration;
    private array $products = [];

    public function __construct(Configuration $configuration, array $products)
    {
        $this->configuration = $configuration;
        $this->products = $products;
    }

    /**
     * @inheritDoc
     */
    public function get(): \Generator
    {
        foreach ($this->products as $product) {
            $document = new ProductDocument(
                FacetFactory::createFromProperty(new Property('category_id', PropertyType::BASE), $product['category'])
            );
            //todo по-хорошему нужны базовые классы, которые будут описывать свойства
            // и формировать структуру для последующей обработки

            $data = [
                'id' => $product['id'],
            ];

            if (isset($product['name'])) {
                $document->setSearchContent($product['name']);
                $data['title'] = $product['name'];
            }

            $document->setAdditionData($data);

            if (isset($product['properties'])) {
                foreach ($product['properties'] as $key => $value) {
                    if ($key === 'price') {
                        $document->getNumberFacets()->add(
                            FacetFactory::createFromProperty(new Property($key, PropertyType::NUMBER), $value)
                        );
                    } else {
                        $document->getKeywordFacets()->add(
                            FacetFactory::createFromProperty(new Property($key, PropertyType::KEYWORD), $value)
                        );
                    }
                }
            }

            $product['type'] = $product['type'] ?? null;
            switch ($product['type']) {
                case 'update':
                    $document->skipEmpty(true);
                    $index = new UpdateIndex(
                        $this->configuration->getIndexName(),
                        $document,
                        $product['id']
                    );
                    break;
                case 'delete':
                    $index = new DeleteIndex(
                        $this->configuration->getIndexName(),
                        $product['id']
                    );
                    break;
                default:
                    $index = new AddIndex(
                        $this->configuration->getIndexName(),
                        $document,
                        $product['id']
                    );
                    break;
            }

            yield $index;
        }
    }

    /**
     * @inheritDoc
     */
    public function setBatchSize(int $size): void
    {
    }

    /**
     * @inheritDoc
     */
    public function getBatchSize(): ?int
    {
        return null;
    }

    /**
     * @inheritDoc
     */
    public function setLimit(int $limit): void
    {
    }

    /**
     * @inheritDoc
     */
    public function getLimit(): ?int
    {
        return null;
    }
}