<?php

namespace IQDEV\ElasticSearchTests\Filter;

use IQDEV\ElasticSearch\Criteria\Criteria;
use IQDEV\ElasticSearch\Criteria\Filter\Collection\FilterGroupCollection;
use IQDEV\ElasticSearch\Criteria\Filter\Field;
use IQDEV\ElasticSearch\Criteria\Filter\Filter;
use IQDEV\ElasticSearch\Criteria\Filter\FilterOperator;
use IQDEV\ElasticSearch\Criteria\Filter\Value\FilterNumber;
use IQDEV\ElasticSearch\Criteria\Query\SearchQuery;
use IQDEV\ElasticSearchTests\AbstractTestCase;
use IQDEV\ElasticSearchTests\Helpers\FormatData;
use IQDEV\ElasticSearchTests\Service\SearchClient;

class RangeTest extends AbstractTestCase
{
    /**
     * Поиск элементов по мин цене
     *
     * @return void
     */
    public function testExistByMinPrice(): void
    {
        $criteria = new Criteria();

        $criteria->getFilters()->add(new FilterGroupCollection([
            new Filter(
                new Field('price'),
                FilterOperator::GTE,
                new FilterNumber(103)
            ),
        ]));

        $q = new SearchQuery($criteria);

        $handler = SearchClient::getInstance();
        $result = $handler->handle($q)->result;


        $expected = [
            'hits' => [
                's4',
                'h1',
                'h2',
                'h3',
                'p1'
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по мин цене
     *
     * @return void
     */
    public function testExistByMinPrice2(): void
    {
        $criteria = new Criteria();

        $criteria->getFilters()->add(new FilterGroupCollection([
            new Filter(
                new Field('price'),
                FilterOperator::GT,
                new FilterNumber(103.01)
            ),
        ]));

        $q = new SearchQuery($criteria);

        $handler = SearchClient::getInstance();
        $result = $handler->handle($q)->result;


        $expected = [
            'hits' => [
                'h1',
                'h2',
                'h3',
                'p1'
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по мин цене
     *
     * @return void
     */
    public function testExistByMinPrice3(): void
    {
        $criteria = new Criteria();

        $criteria->getFilters()->add(new FilterGroupCollection([
            new Filter(
                new Field('price'),
                FilterOperator::GT,
                new FilterNumber(102.99)
            ),
        ]));

        $q = new SearchQuery($criteria);

        $handler = SearchClient::getInstance();
        $result = $handler->handle($q)->result;


        $expected = [
            'hits' => [
                's4',
                'h1',
                'h2',
                'h3',
                'p1'
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по макс цене
     *
     * @return void
     */
    public function testExistByMaxPrice(): void
    {
        $criteria = new Criteria();

        $criteria->getFilters()->add(new FilterGroupCollection([
            new Filter(
                new Field('price'),
                FilterOperator::LTE,
                new FilterNumber(102)
            ),
        ]));

        $q = new SearchQuery($criteria);

        $handler = SearchClient::getInstance();
        $result = $handler->handle($q)->result;


        $expected = [
            'hits' => [
                's1',
                's2',
                's3',
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по макс цене
     *
     * @return void
     */
    public function testExistByMaxPrice2(): void
    {
        $criteria = new Criteria();

        $criteria->getFilters()->add(new FilterGroupCollection([
            new Filter(
                new Field('price'),
                FilterOperator::LT,
                new FilterNumber(102.99)
            ),
        ]));

        $q = new SearchQuery($criteria);

        $handler = SearchClient::getInstance();
        $result = $handler->handle($q)->result;


        $expected = [
            'hits' => [
                's1',
                's2',
                's3',
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по макс цене
     *
     * @return void
     */
    public function testExistByMaxPrice3(): void
    {
        $criteria = new Criteria();

        $criteria->getFilters()->add(new FilterGroupCollection([
            new Filter(
                new Field('price'),
                FilterOperator::LT,
                new FilterNumber(101.99)
            ),
        ]));

        $q = new SearchQuery($criteria);

        $handler = SearchClient::getInstance();
        $result = $handler->handle($q)->result;


        $expected = [
            'hits' => [
                's1',
                's2',
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по диапазону цен
     *
     * @return void
     */
    public function testExistByRangePrice(): void
    {
        $criteria = new Criteria();

        $criteria->getFilters()->add(new FilterGroupCollection([
            new Filter(
                new Field('price'),
                FilterOperator::GTE,
                new FilterNumber(101)
            ),
            new Filter(
                new Field('price'),
                FilterOperator::LTE,
                new FilterNumber(102)
            ),
        ]));

        $q = new SearchQuery($criteria);

        $handler = SearchClient::getInstance();
        $result = $handler->handle($q)->result;


        $expected = [
            'hits' => [
                's2',
                's3',
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по диапазону цен
     *
     * @return void
     */
    public function testExistByRangePrice2(): void
    {
        $criteria = new Criteria();

        $criteria->getFilters()->add(new FilterGroupCollection([
            new Filter(
                new Field('price'),
                FilterOperator::GTE,
                new FilterNumber(101.01)
            ),
            new Filter(
                new Field('price'),
                FilterOperator::LTE,
                new FilterNumber(102)
            ),
        ]));

        $q = new SearchQuery($criteria);

        $handler = SearchClient::getInstance();
        $result = $handler->handle($q)->result;


        $expected = [
            'hits' => [
                's3',
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по диапазону цен
     *
     * @return void
     */
    public function testExistByRangePrice3(): void
    {
        $criteria = new Criteria();

        $criteria->getFilters()->add(new FilterGroupCollection([
            new Filter(
                new Field('price'),
                FilterOperator::GTE,
                new FilterNumber(101)
            ),
            new Filter(
                new Field('price'),
                FilterOperator::LTE,
                new FilterNumber(101.99)
            ),
        ]));

        $q = new SearchQuery($criteria);

        $handler = SearchClient::getInstance();
        $result = $handler->handle($q)->result;


        $expected = [
            'hits' => [
                's2',
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по диапазону цен
     *
     * @return void
     */
    public function testExistByRangePrice4(): void
    {
        $criteria = new Criteria();

        $criteria->getFilters()->add(new FilterGroupCollection([
            new Filter(
                new Field('price'),
                FilterOperator::GTE,
                new FilterNumber(101.99)
            ),
            new Filter(
                new Field('price'),
                FilterOperator::LTE,
                new FilterNumber(101.99)
            ),
        ]));

        $q = new SearchQuery($criteria);

        $handler = SearchClient::getInstance();
        $result = $handler->handle($q)->result;


        $expected = [
            'hits' => []
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }
}