<?php

namespace IQDEV\ElasticSearch\Facet\Type;

use IQDEV\ElasticSearch\Facet\Facet;

final class KeywordFacet extends Facet
{
    /**
     * @inheritDoc
     */
    public function es(): array
    {
        $value = is_array($this->value) ?
            array_map(static fn($value) => (string) $value, $this->value) :
            (string) $this->value;

        return [
            'facet_code' => $this->property->getKey(),
            'facet_value' => $value
        ];
    }
}
