<?php

namespace IQDEV\ElasticSearch\Criteria\Order;

use IQDEV\ElasticSearch\Esable;
use Ramsey\Collection\AbstractCollection;

class OrderCollection extends AbstractCollection implements Esable
{

    /**
     * @inheritDoc
     */
    public function getType(): string
    {
        return Order::class;
    }

    /**
     * @inheritDoc
     */
    public function es(): array
    {
        return array_map(static fn(Order $order) => $order->es(), $this->toArray());
    }
}
