<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Converter\Request;

use IQDEV\ElasticSearch\Search\Request;

abstract class RequestBuilder
{
    public function __construct(
        protected Request $request = new Request(),
    ) {
    }

    public function getRequest(): Request
    {
        return $this->request;
    }

    abstract public function setPagination(): void;
    abstract public function setSort(): void;
    abstract public function setSearch(): void;
    abstract public function setFilter(): void;
    abstract public function setAggregations(): void;
    abstract public function build(): void;
}
