<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Converter\Request\Filter\Type;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Criteria\Filter\Collection\FilterCollection;
use IQDEV\ElasticSearch\Criteria\Filter\Collection\FilterGroupCollection;
use IQDEV\ElasticSearch\Criteria\Filter\Filter;
use IQDEV\ElasticSearch\Search\BoolQuery\Stats;

class RangeFilterType extends AbstractFilterType
{
    public function __construct(
        private readonly FilterGroupCollection $filterGroupCollection,
    ) {
        $this->field = $this->filterGroupCollection->first()->field()->value();
    }

    public function getEsable(): Esable
    {
        $ranges = [];

        foreach ($this->filterGroupCollection as $filter) {
            /** @var Filter $filter */

            $value = $filter->value()->value();
            $ranges[$filter->operator()->value] = $value;
        }

        return new Stats($this->field, $ranges);
    }

    public static function getFiltersByOneProperty(FilterGroupCollection $filterGroupCollection): FilterCollection
    {
        $rangeFilters = new FilterCollection();

        $properties = [];
        foreach ($filterGroupCollection as $filter) {
            /** @var Filter $filter */

            $properties[$filter->field()->value()][] = $filter;
        }

        foreach ($properties as $propertyFilters) {
            $rangeFilters->add(new FilterGroupCollection($propertyFilters));
        }

        return $rangeFilters;
    }
}
