<?php

namespace IQDEV\ElasticSearchTests\Service;

use Elastic\Elasticsearch\ClientBuilder;
use IQDEV\ElasticSearch\Domain\SearchService;
use IQDEV\Search\SearchQuery\SearchQueryHandler;

class SearchClient
{
    private function __construct() { }

    protected static SearchQueryHandler $oInstance;

    public static function getInstance(): SearchQueryHandler
    {
        if (!isset(static::$oInstance)) {
            static::$oInstance = new SearchQueryHandler(
                new SearchService(
                    ClientBuilder::create()
                        ->setHosts(explode(',', 'http://localhost:9200'))
                        ->setBasicAuthentication('elastic', 'DkIedPPSCb')
                        ->build(),
                    'product-test'
                )
            );
        }
        
        return static::$oInstance;
    }
}