<?php

namespace Docke\CLICommands;

use Elastic\Elasticsearch\ClientBuilder;
use IQDEV\ElasticSearch\Document\ProductDocument;
use IQDEV\ElasticSearch\Facet\FacetCategory;
use IQDEV\ElasticSearch\Facet\FacetKeyword;
use IQDEV\ElasticSearch\Facet\FacetNumber;
use IQDEV\ElasticSearch\Indexer\Index;
use IQDEV\ElasticSearch\Indexer\IndexProvider;
use IQDEV\ElasticSearch\Indexer\IndexRunner;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class WorkerProductIndexCommand extends Command
{
    protected function configure(): void
    {
        //todo временная команда для индексации
        $this->setName('worker:product-index')->setDescription('Worker for index product to es');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->indexRunner = new IndexRunner(
            ClientBuilder::create()
                ->setHosts(explode(',', 'http://localhost:9200'))
                ->setBasicAuthentication('elastic', 'DkIedPPSCb')
                ->build()
        );

        $provider = new class implements IndexProvider {
            public function get(): \Generator
            {
                $products = [
                    [
                        'id' => 's1',
                        'name' => 'Кроссовки NMD_R1 Boba Fett Spectoo',
                        'category' => 'shoes',
                        'properties' => ['brand' => 'adidas', 'color' => 'green', 'size' => 46,'price' => 100]
                    ],
                    [
                        'id' => 's2',
                        'name' => 'КРОССОВКИ ULTRABOOST 5.0 DNA',
                        'category' => 'shoes',
                        'properties' => ['brand' => 'adidas', 'color' => 'red', 'size' => 47,'price' => 101]
                    ],
                    [
                        'id' => 's3',
                        'name' => 'Кроссовки Reebok Royal Techque',
                        'category' => 'shoes',
                        'properties' => ['brand' => 'rebook', 'color' => 'blue', 'size' => 47,'price' => 102]
                    ],
                    [
                        'id' => 's4',
                        'name' => 'Nike Air Zoom Pegasus 39',
                        'category' => 'shoes',
                        'properties' => ['brand' => 'nike', 'color' => 'green', 'size' => 43,'price' => 103]
                    ],
                    [
                        'id' => 'h1',
                        'name' => 'Nike Dri-FIT Strike',
                        'category' => 't-short',
                        'properties' => ['brand' => 'nike', 'color' => 'red', 'size' => 'xl','price' => 104]
                    ],
                    [
                        'id' => 'h2',
                        'name' => 'Nike Dri-FIT Rise 365',
                        'category' => 't-short',
                        'properties' => ['brand' => 'nike', 'color' => 'white', 'size' => 'xxl','price' => 105]
                    ],
                    [
                        'id' => 'h3',
                        'name' => 'Компрессионная Футболка ACTIVCHILL Graphic Move',
                        'category' => 't-short',
                        'properties' => ['brand' => 'rebook', 'color' => 'white', 'size' => 'xl','price' => 106]
                    ],
                    [
                        'id' => 'p1',
                        'name' => 'Товар с ценой',
                        'category' => 'prices',
                        'properties' => ['brand' => 'rebook', 'color' => 'white', 'size' => 'xl','price' => 107]
                    ],
                ];

                foreach ($products as $product) {
                    $document = new ProductDocument(new FacetCategory($product['category']));
                    //todo по-хорошему нужны базовые классы, которые будут описывать свойства
                    // и формировать структуру для последующей обработки
                    foreach ($product['properties'] as $key => $prop) {
                        var_dump([$key, $prop]);
                        if ($key === 'price') {
                            $document->getNumberFacets()->add(new FacetNumber($key, $prop));
                        } else {
                            $document->getKeywordFacets()->add(new FacetKeyword($key, $prop));
                        }
                    }
                    $document->setFullSearchContent($product['name']);
                    dump($document);

                    yield new Index(
                        'product-test',
                        $document,
                        $product['id']
                    );
                }
            }
        };

        $this->indexRunner->run($provider);
        return Command::SUCCESS;
    }
}
