<?php

namespace IQDEV\ElasticSearchTests\FIlter;

use IQDEV\ElasticSearchTests\Helpers\FormatData;
use IQDEV\ElasticSearchTests\Service\SearchClient;
use IQDEV\Search\SearchQuery\SearchQuery;
use PHPUnit\Framework\TestCase;

class KeywordsTest extends TestCase
{
    /**
     * Поиск элементов по пустому фильтру свойства
     *
     * @return void
     */
    public function testExistByEmptyFilter(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'color' => []
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => []
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по фильтру свойства
     *
     * @return void
     */
    public function testExistByFilter(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'color' => ['red']
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                's2',
                'h1'
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по фильтру свойства и категории
     *
     * @return void
     */
    public function testExistByFilterAndCategory(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'color' => ['red'],
                    'categoryId' => 'shoes'
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                's2',
            ]
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по нескольким свойствам
     *
     * @return void
     */
    public function testExistByMultipleFilter(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'color' => ['red'],
                    'size' => ['xxl']
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
            ]
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по нескольким свойствам
     *
     * @return void
     */
    public function testExistByMultipleFilter2(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'color' => ['red'],
                    'size' => ['xl']
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                'h1'
            ]
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по нескольким свойствам и категории
     *
     * @return void
     */
    public function testExistByMultipleFilterAndCategory(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'color' => ['red'],
                    'size' => ['xl'],
                    'categoryId' => ['prices']
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
            ]
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }
}