<?php

namespace IQDEV\ElasticSearchTests\FIlter;

use IQDEV\ElasticSearchTests\Helpers\FormatData;
use IQDEV\ElasticSearchTests\Service\SearchClient;
use IQDEV\Search\SearchQuery\SearchQuery;
use PHPUnit\Framework\TestCase;

class CommonRangeKeywordsTest extends TestCase
{
    /**
     * Поиск элементов по фильтру свойства и цене
     *
     * @return void
     */
    public function testExistByFilterAndMinPrice(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'color' => ['red'],
                    'price' => ['min' => 102]
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                'h1'
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по фильтру свойства и цене
     *
     * @return void
     */
    public function testExistByFilterAndMaxPrice(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'color' => ['red'],
                    'price' => ['max' => 102]
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                's2'
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по фильтру свойства и цене
     *
     * @return void
     */
    public function testExistByFilterAndRangePrice(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'color' => ['red'],
                    'price' => ['min' => 101, 'max' => 104]
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                'h1',
                's2'
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }
}