<?php

namespace IQDEV\ElasticSearch\Indexer;

use IQDEV\ElasticSearch\Esable;

final class Index implements Esable
{
    private string $name;
    private Esable $body;
    private ?string $id;
    
    public function __construct(
        string $name,
        Esable $body,
        ?string $id = null
    ) {
        $this->name = $name;
        $this->body = $body;
        $this->id = $id;
    }

    public function es(): array
    {
        $es = [
            'index' => $this->name,
            'body' => $this->body->es(),
        ];

        if ($this->id) {
            $es['id'] = $this->id;
        }

        return $es;
    }
}
