<?php

namespace IQDEV\ElasticSearchTests\Filter;

use Elastic\Elasticsearch\Client;
use IQDEV\ElasticSearch\Configuration;
use IQDEV\ElasticSearch\Converter\Result\EsResponseToResult;
use IQDEV\ElasticSearch\Indexer\IndexRunner;
use IQDEV\ElasticSearchTests\AbstractTestCase;
use IQDEV\ElasticSearchTests\Config\ChangingStateConfiguration;
use IQDEV\ElasticSearchTests\Factory\ClientFactory;
use IQDEV\ElasticSearchTests\Helpers\FormatData;
use IQDEV\ElasticSearchTests\Helpers\TestIndexProvider;
use Psr\Log\NullLogger;

class IndexesTest extends AbstractTestCase
{
    private array $product = [
        'id' => 'test',
        'name' => 'Test товар',
        'category' => 'indexes',
        'properties' => [
            'prop1' => 'value1',
            'prop2' => 'value2',
            'prop3' => 'value3',
        ]
    ];

    private IndexRunner $indexRunner;
    private Client $esClient;
    private Configuration $configuration;

    public function __construct(?string $name = null, array $data = [], $dataName = '')
    {
        parent::__construct($name, $data, $dataName);

        $this->configuration = new ChangingStateConfiguration();
        $this->esClient = ClientFactory::create();

        $this->indexRunner = new IndexRunner(
            $this->esClient,
            $this->configuration,
            new NullLogger()
        );
    }

    public function testUpdate()
    {
        $indexProvider = new TestIndexProvider($this->configuration, [$this->product]);
        $this->indexRunner->run($indexProvider);

        $updateData = [
            'id' => $this->product['id'],
            'category' => $this->product['category'],
            'type' => 'update',
            'name' => 'Обновленный элемент'
        ];
        $indexProvider = new TestIndexProvider($this->configuration, [$updateData]);
        $this->indexRunner->run($indexProvider);

        $response = $this->esClient->search([
            'index' => $this->configuration->getIndexName(),
            'body' => [
                'query' => [
                    'match' => [
                        '_id' => $this->product['id']
                    ],
                ]
            ]
        ]);
        $esResponseToResult = new EsResponseToResult();
        $result = $esResponseToResult->fromResponse($response, $this->configuration);

        unset($updateData['type']);
        $expected = [
            'products' => [
                array_merge($this->product, $updateData)
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatDataProducts($result));
    }
}
