<?php

namespace IQDEV\ElasticSearch\Facet\Item;

class FacetItemRange extends FacetItem
{
    protected FacetItemRangeDTO $data;
    protected ?FacetItemRangeDTO $selectedData;

    public static function create(
        FacetItemRangeDTO $data = null,
        FacetItemRangeDTO $selectedData = null,
        int               $count = 0,
        bool              $selected = false,
        ?string           $label = null
    ): self
    {
        $instance = new self();

        $instance->label = $label;
        $instance->count = $count;
        $instance->selected = $selected;

        $instance->data = $data;
        $instance->selectedData = $selectedData;

        return $instance;
    }

    public function getFullRange(): array
    {
        return [
            'min' => $this->data->min,
            'max' => $this->data->max
        ];
    }

    public function getSelectedRange(): array
    {
        return [
            'min' => $this->selectedData->min,
            'max' => $this->selectedData->max
        ];
    }

    public function getData(): FacetItemRangeDTO
    {
        return $this->data;
    }

    public function getSelectedData(): FacetItemRangeDTO
    {
        return $this->selectedData;
    }
}
