<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Criteria\Search;

use IQDEV\ElasticSearch\Document\Property\Property;

class Search
{
    public function __construct(
        private readonly Property $property,
        private readonly mixed $value,
    ) {
    }

    public function getProperty(): Property
    {
        return $this->property;
    }

    public function getValue(): mixed
    {
        return $this->value;
    }
}
