<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Converter\Request;

use IQDEV\ElasticSearch\Configuration;
use IQDEV\ElasticSearch\Criteria\Criteria;
use IQDEV\ElasticSearch\Search\Request;

final class CriteriaToRequest
{
    public function __construct(
        private readonly Configuration $configuration,
    ) {
    }

    public function fromCriteria(Criteria $criteria): Request
    {
        $builder = new CriteriaRequestBuilder($this->configuration, $criteria);
        $builder->build();

        return $builder->getRequest();
    }
}
