<?php

namespace IQDEV\ElasticSearch\Helper;

class ArrayHelper
{
    /**
     * Recursively filter an array
     *
     * @param array $array
     * @param callable|null $callback
     *
     * @return array
     */
    public static function array_filter_recursive(array $array, ?callable $callback = null): array
    {
        $array = is_callable($callback) ? array_filter($array, $callback) : array_filter($array);
        foreach ($array as $key => &$value) {
            if (is_array($value)) {
                $value = call_user_func([__CLASS__, __FUNCTION__], $value, $callback);

                if (!empty($value)) {
                    $value = self::array_filter_recursive($value, $callback);
                } else {
                    unset($array[$key]);
                }
            }
        }

        return $array;
    }
}