<?php

namespace IQDEV\ElasticSearchTests\Helpers;

use IQDEV\ElasticSearch\Document\Product;
use IQDEV\ElasticSearch\Facet\Facet;
use IQDEV\ElasticSearch\Facet\Item\FacetItemList;
use IQDEV\ElasticSearch\Facet\Item\FacetItemRange;
use IQDEV\ElasticSearch\Facet\Type\FacetListType;
use IQDEV\ElasticSearch\Facet\Type\FacetRangeType;
use IQDEV\ElasticSearch\Result;

class FormatData
{
    public static function formatData(Result $result): array
    {
        $oProductCollection = $result->getProducts();
        $aResult = ['hits' => []];
        foreach ($oProductCollection as $oProduct) {
            /** @var Product $oProduct */
            $aResult['hits'][] = $oProduct->id;
        }
        return $aResult;
    }

    public static function formatDataWFacets(Result $result): array
    {
        $aResult         = ['facets' => []];
        $aResult['hits'] = static::formatData($result)['hits'];
        foreach ($result->getFacets() as $facet) {
            /** @var Facet $facet */
            $dataFacet = [
                'code' => $facet->getCode(),
                'label' => null, // $facet->getLabel(),
                'type' => $facet->getType() instanceof FacetRangeType ? 'range' : ($facet->getType() instanceof FacetListType ? 'list' : null),
                'items' => [
                    'list' => [],
                    'range' => []
                ],
            ];

            $items = $facet->products->sort('getValue');
            foreach ($items as $item) {
                if ($item instanceof FacetItemList) {
                    /** @var FacetItemList $item */
                    $dataFacet['items']['list'][] = [
                        'label' => $item->getLabel(),
                        'value' => $item->getValue(),
                        'count' => $item->getCount(),
                        'active' => $item->isActive(),
                    ];
                }
                if ($item instanceof FacetItemRange) {
                    /** @var FacetItemRange $item */

                    $aData = [
                        'label' => $item->getLabel(),
                        'count' => $item->getCount(),
                        'active' => $item->isActive(),
                    ];
                    
                    $aData['fullRange']   = $item->getFullRange();
                    $aData['activeRange'] = $item->getSelectedRange();
                    
                    if ($result->getTotal() > 0 && empty(array_filter($aData['activeRange']))) {
                        $aData['activeRange'] = $aData['fullRange']; 
                    }

                    $dataFacet['items']['range'][] = $aData;
                }
            }

            $aResult['facets'][] = $dataFacet;
        }
        return $aResult;
    }

    public static function formatDataProducts(Result $result): array
    {
        $products = [];
        /** @var Product $product */
        foreach ($result->getProducts() as $product) {
            $data = [
              'id' => $product->id,
              'category' => $product->info['category_id']
            ];

            if ($product->title) {
                $data['name'] = $product->title;
            }

            if (isset($product->info['search_data'])) {
                $props = $product->info['search_data'];
                if (!empty($props['keyword_facet'])) {
                    foreach ($props['keyword_facet'] as $prop) {
                        $data['properties'][$prop['facet_code']] = $prop['facet_value'];
                    }
                }
                if (!empty($props['number_facet'])) {
                    foreach ($props['number_facet'] as $prop) {
                        $data['properties'][$prop['facet_code']] = $prop['facet_value'];
                    }
                }
            }

            $products[] = $data;
        }
        return ['products' => $products];
    }
}