<?php

namespace IQDEV\ElasticSearchTests\Helpers;

use IQDEV\ElasticSearch\Configuration;
use IQDEV\ElasticSearch\Document\ProductDocument;
use IQDEV\ElasticSearch\Facet\FacetCategory;
use IQDEV\ElasticSearch\Facet\FacetKeyword;
use IQDEV\ElasticSearch\Facet\FacetNumber;
use IQDEV\ElasticSearch\Indexer\AddIndex;
use IQDEV\ElasticSearch\Indexer\DeleteIndex;
use IQDEV\ElasticSearch\Indexer\IndexProvider;
use IQDEV\ElasticSearch\Indexer\UpdateIndex;

class TestIndexProvider implements IndexProvider
{

    private Configuration $configuration;
    private array $products = [];

    public function __construct(Configuration $configuration, array $products)
    {
        $this->configuration = $configuration;
        $this->products = $products;
    }

    /**
     * @inheritDoc
     */
    public function get(): \Generator
    {
        foreach ($this->products as $product) {
            $document = new ProductDocument(new FacetCategory($product['category']));
            //todo по-хорошему нужны базовые классы, которые будут описывать свойства
            // и формировать структуру для последующей обработки

            $data = [
                'id' => $product['id'],
            ];

            if (isset($product['name'])) {
                $document->setSearchContent($product['name']);
                $data['title'] = $product['name'];
            }

            $document->setAdditionData($data);

            if (isset($product['properties'])) {
                foreach ($product['properties'] as $key => $prop) {
                    if ($key === 'price') {
                        $document->getNumberFacets()->add(new FacetNumber($key, $prop));
                    } else {
                        $document->getKeywordFacets()->add(new FacetKeyword($key, $prop));
                    }
                }
            }

            $product['type'] = $product['type'] ?? null;
            switch ($product['type']) {
                case 'update':
                    $document->skipEmpty(true);
                    $index = new UpdateIndex(
                        $this->configuration->getIndexName(),
                        $document,
                        $product['id']
                    );
                    break;
                case 'delete':
                    $index = new DeleteIndex(
                        $this->configuration->getIndexName(),
                        $product['id']
                    );
                    break;
                default:
                    $index = new AddIndex(
                        $this->configuration->getIndexName(),
                        $document,
                        $product['id']
                    );
                    break;
            }

            yield $index;
        }
    }

    /**
     * @inheritDoc
     */
    public function setBatchSize(int $size): void
    {
    }

    /**
     * @inheritDoc
     */
    public function getBatchSize(): ?int
    {
        return null;
    }

    /**
     * @inheritDoc
     */
    public function setLimit(int $limit): void
    {
    }

    /**
     * @inheritDoc
     */
    public function getLimit(): ?int
    {
        return null;
    }
}