<?php

namespace IQDEV\ElasticSearch\Search\BoolQuery;

use IQDEV\ElasticSearch\Esable;

final class Stats implements Esable
{
    /**
     * @param string $key
     * @param string|float|array<string|float> $value
     */
    public function __construct(
        private string $key,
        private string|float|array $value
    ) {
    }

    public function es(): array
    {
        $keyStats = is_array($this->value) ? 'range' : 'term';

        return [
            $keyStats => [
                $this->key => $this->value,
            ],
        ];
    }
}
