<?php

namespace IQDEV\ElasticSearch\Search\BoolQuery;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Search\Nested;

final class FilterKeywordFacet implements Esable
{
    /**
     * @param string $key
     * @param string|array<string> $value
     */
    public function __construct(
        public string $key,
        public string|array $value
    ) {
    }

    public function es(): array
    {
        $path = 'search_data.keyword_facet';

        $nested = new Nested();

        $query = new Query();
        $query
            ->filter(new Terms($path . '.facet_code', $this->key))
            ->filter(new Terms($path . '.facet_value', $this->value));

        $nested
            ->setPath($path)
            ->setQuery($query);

        return $nested->es();
    }
}
