<?php

namespace IQDEV\ElasticSearch\Indexer;

use IQDEV\ElasticSearch\Esable;

final class AddIndex implements Index
{
    public function __construct(
        private string  $name,
        private Esable  $body,
        private ?string $id = null
    )
    {
    }

    public function es(): array
    {
        $es = [
            'index' => $this->name,
            'body' => $this->body->es(),
        ];

        if ($this->id) {
            $es['id'] = $this->id;
        }

        return $es;
    }
}
