<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Converter\Request\Aggregation;

use IQDEV\ElasticSearch\Configuration;
use IQDEV\ElasticSearch\Converter\Request\FilterQuery;
use IQDEV\ElasticSearch\Criteria\Filter\Collection\FilterCollection;
use IQDEV\ElasticSearch\Criteria\Filter\Collection\FilterGroupCollection;
use IQDEV\ElasticSearch\Criteria\Filter\Filter;
use IQDEV\ElasticSearch\Search\Aggs\Aggs;
use IQDEV\ElasticSearch\Search\Aggs\AggsCollection;
use IQDEV\ElasticSearch\Search\Aggs\AggsFacetTerms;
use IQDEV\ElasticSearch\Search\Nested;

class FilterAggregation
{
    private ?Aggs $aggregation = null;

    public function __construct(
        private readonly Configuration $configuration,
        private readonly FilterCollection $filterCollection,
    ) {
    }

    public function updateRequestAggregation(AggsCollection $original): void
    {
        foreach ($this->filterCollection as $filterGroup) {
            /** @var FilterGroupCollection $filterGroup */

            foreach ($filterGroup as $filter) {
                /** @var Filter $filter */

                $field = $filter->field()->value();

                $aggregation = new Aggs($this->getKey('keyword', $field));
                $aggregation->addAggs(
                    AggsFacetTerms::create(
                        'agg_special',
                        'keyword_facet'
                    )
                );

                $queryFilterBuilder = new FilterQuery($this->configuration, $this->filterCollection, [$field]);
                $query = $queryFilterBuilder->getQuery();

                if (false === $query->isEmpty()) {
                    $aggregation->setQuery($query);
                } else {
                    $aggregation->setNested((new Nested())->setPath('search_data'));
                }

                $original->add($aggregation);
            }
        }
    }

    private function getKey(string $type, string $name): string
    {
        return sprintf('%s_facet_%s', $type, $name);
    }
}
