<?php

namespace IQDEV\ElasticSearch;

use Elastic\Elasticsearch\Client;
use Elastic\Elasticsearch\Exception\ClientResponseException;
use Elastic\Elasticsearch\Exception\ServerResponseException;
use IQDEV\ElasticSearch\Converter\CriteriaToRequest;
use IQDEV\ElasticSearch\Converter\EsResponseToResult;

class SearchService implements Searchable
{
    private CriteriaToRequest $criteriaToEsRequest;
    private EsResponseToResult $esResponseToResult;

    public function __construct(
        private Client $esClient,
        private Configuration $configuration
    ) {
        $this->criteriaToEsRequest = new CriteriaToRequest($this->configuration);
        $this->esResponseToResult = new EsResponseToResult();
    }

    /**
     * @throws ServerResponseException
     * @throws ClientResponseException
     */
    public function search(Criteria $criteria): Result
    {
        $request = $this->criteriaToEsRequest->fromCriteria($criteria);

        $response = $this->esClient->search([
            'index' => $this->configuration->getIndexName(),
            'body' => $request->es(),
        ]);

        return $this->esResponseToResult->fromResponse($response);
    }
}
