<?php

namespace IQDEV\ElasticSearch\Search\Aggs;

use IQDEV\ElasticSearch\Esable;

final class Terms implements Esable
{
    private array $options = [];

    public function __construct(
        private string $field
    ) {
    }

    public function setSize(int $size): self
    {
        $this->options['size'] = $size;

        return $this;
    }

    public function es(): array
    {
        $data = $this->options;
        $data['field'] = $this->field;

        return ['terms' => $data];
    }
}
