<?php

namespace IQDEV\ElasticSearch\Request\Query;

use IQDEV\ElasticSearch\SearchService;

final class SearchQueryHandler
{
    public function __construct(
        private SearchService $searchService
    ) {
    }

    public function handle(SearchQuery $q): SearchQueryResponse
    {
        $result = $this->searchService->search($q->criteria);

        return new SearchQueryResponse($result);
    }
}
