<?php

namespace IQDEV\ElasticSearch\Request\Order\Type;

use IQDEV\ElasticSearch\Request\Order\Order;

class KeywordPropertyOrder extends Order
{
    public function es(): array
    {
        $order = [
            'order' => $this->direction->value,
            'nested' => [
                'path' => 'search_data',
                'filter' => [
                    'bool' => [
                        'must' => [
                            'term' => [
                                'search_data.keyword_facet.facet_code' => $this->property->getKey(),
                            ],
                        ],
                    ],
                ],
            ],
        ];

        return [
            'search_data.keyword_facet.facet_value' => array_merge(
                $order,
                $this->additionalParams
            ),
        ];
    }
}
