<?php

namespace IQDEV\ElasticSearch\Request\Filter\Collection;

use IQDEV\ElasticSearch\Request\Filter\Filter;
use IQDEV\ElasticSearch\Request\Filter\FilterOperator;
use IQDEV\ElasticSearch\Request\Filter\FilterType;
use IQDEV\ElasticSearch\Request\Filter\LogicOperator;
use Ramsey\Collection\AbstractCollection;

/**
 * @method bool add(Filter $item)
 */
class FilterGroupCollection extends AbstractCollection
{
    /** @var LogicOperator Тип логической операции для коллекции */
    protected LogicOperator $logicOperator;
    /** @var FilterType Тип фильтра для коллекции */
    protected FilterType $filterType;

    /**
     * @param Filter[] $data
     */
    public function __construct(array $data = [])
    {
        parent::__construct($data);
        $this->logicOperator = LogicOperator::AND;
        $this->filterType = FilterType::POST;
    }

    /**
     * @inheritDoc
     */
    public function getType(): string
    {
        return Filter::class;
    }

    /**
     * Установка типа логической операции
     *
     * @param LogicOperator $type
     *
     * @return $this
     */
    public function setLogicOperator(LogicOperator $type): self
    {
        $this->logicOperator = $type;

        return $this;
    }

    /**
     * Получение типа логической операции
     *
     * @return LogicOperator
     */
    public function getLogicOperator(): LogicOperator
    {
        return $this->logicOperator;
    }

    /**
     * Установка типа фильтрации
     *
     * @param FilterType $type
     *
     * @return $this
     */
    public function setFilterType(FilterType $type): self
    {
        $this->filterType = $type;

        return $this;
    }

    /**
     * Получение типа фильтрации
     *
     * @return FilterType
     */
    public function getFilterType(): FilterType
    {
        return $this->filterType;
    }

    public function getKeywordFilters(array $excludeFilter = []): FilterGroupCollection
    {
        return $this->getFilters(false, $excludeFilter);
    }

    public function getRangeFilters(array $excludeFilter = []): FilterGroupCollection
    {
        return $this->getFilters(true, $excludeFilter);
    }

    private function getFilters(bool $range = false, array $excludeFilter = []): FilterGroupCollection
    {
        $filterGroup = new FilterGroupCollection();
        $filterGroup->setLogicOperator($this->getLogicOperator());

        foreach ($this->data as $filter) {
            /** @var Filter $filter */

            $field = $filter->field()->value();

            if (false === in_array($field, $excludeFilter, true)
                && $range === in_array($filter->operator(), [
                    FilterOperator::LT,
                    FilterOperator::LTE,
                    FilterOperator::GT,
                    FilterOperator::GTE
                ], true)
            ) {
                $filterGroup->add($filter);
            }
        }

        return $filterGroup;
    }
}
