<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Converter\Request\Filter;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Request\Filter\Collection\FilterGroupCollection;
use IQDEV\ElasticSearch\Request\Filter\LogicOperator;
use IQDEV\ElasticSearch\Search\BoolQuery\Query;
use IQDEV\ElasticSearch\Search\Nested;

abstract class AbstractFilterQuery
{
    protected Query $query;

    public function __construct() {
        $this->query = new Query();
    }

    protected function setFilterByLogic(LogicOperator $logicOperator, Esable $filter): void
    {
        match ($logicOperator) {
            LogicOperator::AND => $this->query->getFilter()->add($filter),
            LogicOperator::OR => $this->query->getShould()->add($filter),
            LogicOperator::NOT => $this->query->getMustNot()->add($filter),
        };
    }

    abstract public function getQuery(FilterGroupCollection $filterGroupCollection): Query|Nested;
}
