<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Converter\Request\Aggregation;

use IQDEV\ElasticSearch\Configuration;
use IQDEV\ElasticSearch\Converter\Request\FilterQuery;
use IQDEV\ElasticSearch\Request\Filter\Collection\FilterCollection;
use IQDEV\ElasticSearch\Search\Aggs\Aggs;
use IQDEV\ElasticSearch\Search\Aggs\AggsFacetStats;
use IQDEV\ElasticSearch\Search\Aggs\AggsFacetTerms;
use IQDEV\ElasticSearch\Search\BoolQuery\Query;
use IQDEV\ElasticSearch\Search\Nested;

class FullAggregation
{
    private Query $queryKeywordFiltered;
    private Query $queryNumberFiltered;


    public function __construct(
        private readonly Configuration $configuration,
        private readonly FilterCollection $filterCollection,
    ) {
        $this->queryKeywordFiltered = new Query();
        $this->queryNumberFiltered = new Query();
    }

    public function getKeywordAggregation(): Aggs
    {
        $filterCollection = $this->filterCollection->getKeywordFilters();
        $keywordFilter = (new FilterQuery($this->configuration, $filterCollection))->getQuery();


        if (isset($GLOBALS['DD']) && $GLOBALS['DD'] === true) {
            dump($filterCollection);
            dd($keywordFilter->es());
        }

        $aggsKeywordFiltered = new Aggs('keyword_facet_filtered');
        $aggsKeywordFiltered->addAggs(
            AggsFacetTerms::create(
                'all_keyword_facet_filtered',
                'keyword_facet'
            )
        );

        return $aggsKeywordFiltered;
    }

    public function getRangeAggregation(): Aggs
    {
        $filterCollection = $this->filterCollection->getNumberFilters();

        $aggsNumberFiltered = new Aggs('number_facet_filtered');
        $aggsNumberFiltered->addAggs(
            AggsFacetStats::create(
                'all_number_facet_filtered',
                'number_facet'
            )
        );

        return $aggsNumberFiltered;
    }
}
