<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Converter\Request\Aggregation;

use IQDEV\ElasticSearch\Configuration;
use IQDEV\ElasticSearch\Criteria;
use IQDEV\ElasticSearch\Request\Filter\Collection\FilterGroupCollection;
use IQDEV\ElasticSearch\Request\Filter\Filter;
use IQDEV\ElasticSearch\Request\Filter\FilterType;
use IQDEV\ElasticSearch\Search\Aggs\AggsCollection;
use IQDEV\ElasticSearch\Search\Aggs\AggsFacetStats;
use IQDEV\ElasticSearch\Search\Aggs\AggsFacetTerms;

class Aggregation
{
    public function __construct(
        private readonly Configuration $configuration,
        private readonly Criteria $criteria,
        private readonly AggsCollection $aggregations = new AggsCollection(),
    ) {
        $this->convertToQuery();
    }

    public function convertToQuery(): void
    {
        $this->aggregations->add(
            AggsFacetTerms::create(
                'keyword_facet',
                'keyword_facet'
            )
        );

        $this->aggregations->add(
            AggsFacetStats::create(
                'number_facet',
                'number_facet'
            )
        );

       $postFilterCollection = $this->criteria->getFilters()->getFilterCollectionByType(FilterType::POST);

//        foreach ($postFilterCollection as $filterGroup) {
//            /** @var FilterGroupCollection $filterGroup */
//
//            foreach ($filterGroup as $filter) {
//                /** @var Filter $filter */
//
//                $filterAggregation = new FilterAggregation($this->configuration, $filter, $postFilterCollection);
//
//                if ($aggregation = $filterAggregation->getFilterAggregation()) {
//                    $this->aggregations->add($aggregation);
//                }
//            }
//        }
        $fullAggregation = new FullAggregation($this->configuration, $postFilterCollection);

        $this->aggregations->add($fullAggregation->getKeywordAggregation());
        $this->aggregations->add($fullAggregation->getRangeAggregation());
    }

    public function getAggregation(): AggsCollection
    {
        return $this->aggregations;
    }
}
