<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Converter;

use IQDEV\ElasticSearch\Configuration;
use IQDEV\ElasticSearch\Converter\Request\CriteriaRequestBuilder;
use IQDEV\ElasticSearch\Criteria;
use IQDEV\ElasticSearch\Search\Request;

final class CriteriaToRequest
{
    public function __construct(
        private readonly Configuration $configuration,
    ) {
    }

    public function fromCriteria(Criteria $criteria): Request
    {
        $builder = new CriteriaRequestBuilder($this->configuration, $criteria);
        $builder->build();

        return $builder->getRequest();
    }
}
