<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Config\Mapping;

use IQDEV\ElasticSearch\Mapping;

class ProductMapping extends Mapping
{

    public function getPropertiesMap(): array
    {
        return [
            'data' => [
                'type' => 'object',
                'enabled' => false,
            ],
            'full_search_content' => [
                'type' => 'text',
            ],
            'suggest_search_content' => [
                'type' => 'text',
                'analyzer' => 'autocomplete',
                'search_analyzer' => 'standard',
            ],
            'category_id' => [
                'type' => 'keyword',
                'index' => false,
            ],
            'rating' => [
                'type' => 'double',
                'index' => false,
            ],
            'popular' => [
                'type' => 'double',
                'index' => false,
            ],
        ];
    }
}
