<?php

namespace IQDEV\ElasticSearch\Search\Sorting;

class SortingPropertyKeywordPair extends SortingPair
{
    public function es(): array
    {
        return [
            'search_data.keyword_facet.facet_value' => [
                'order' => $this->direction,
                'nested' => [
                    'path' => 'search_data',
                    'filter' => [
                        'bool' => [
                            'must' => [
                                'term' => [
                                    'search_data.keyword_facet.facet_code' => $this->by,
                                ]
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }
}