<?php

namespace IQDEV\ElasticSearch\Search;

use IQDEV\ElasticSearch\Esable;

class Sorting implements Esable
{
    public string $by;
    public string $direction;

    public function __construct(string $by = '', string $direction = 'asc')
    {
        $this->by = $by;
        $this->direction = $direction;
    }

    public function es(): array
    {
        $sorting = [];

        if ($this->by) {
            $sorting['sort'] = [$this->by => $this->direction];
        }

        return $sorting;
    }
}