<?php

namespace IQDEV\ElasticSearch\Search\Aggs;


use IQDEV\ElasticSearch\Esable;

final class ExtremumTerms implements Esable
{
    private string $field;

    /**
     * @param string $field
     */
    public function __construct(string $field)
    {
        $this->field = $field;
    }

    public function es(): array
    {
        return [
            'stats' => [
                'field' => $this->field,
            ],
        ];
    }
}