<?php

namespace IQDEV\ElasticSearch\Search\Aggs;

use IQDEV\ElasticSearch\Search\Nested;

final class AggsKeyWordFacet
{
    public static function create(string $code, string $facet, string $path = 'search_data'): Aggs
    {
        $aggKeywordFacet = new Aggs($code);
        $nested = new Nested();
        $nested->setPath($path . '.' . $facet);
        $aggKeywordFacet->setNested($nested);

        $aggKeywordFacetCode = new Aggs("agg_{$facet}_code");
        $aggKeywordFacetCode->setTerms(
            (new Terms("{$path}.{$facet}.facet_code"))
                ->setSize(250)
        );

        $aggKeywordFacetValue = new Aggs("agg_{$facet}_value");
        $aggKeywordFacetValue->setTerms(
            (new Terms("{$path}.{$facet}.facet_value"))
                ->setSize(250)
        );

        $aggKeywordFacetCode->addAggs($aggKeywordFacetValue);
        $aggKeywordFacet->addAggs($aggKeywordFacetCode);

        return $aggKeywordFacet;
    }
}
