<?php

namespace IQDEV\ElasticSearch\Facet;

final class FacetNumber implements Facet
{
    public string $key;
    public float $value;
    
    /**
     * @param string $key
     * @param float $value
     */
    public function __construct(
        string $key,
        float $value
    )
    {
        $this->key = $key;
        $this->value = $value;
    }

    public function es(): array
    {
        return [
            'facet_code' => $this->key,
            'facet_value' => $this->value,
        ];
    }
}