<?php

namespace IQDEV\ElasticSearch\Search\BoolQuery;


use IQDEV\ElasticSearch\Esable;

final class Terms implements Esable
{
    private string $key;
    /** @var string|float|string[]|float[] */
    private $value;

    /**
     * @param string $key
     * @param string|float|string[]|float[] $value
     */
    public function __construct(string $key, $value)
    {
        $this->key   = $key;
        $this->value = $value;
    }

    public function es(): array
    {
        $keyTerms = is_array($this->value) ? 'terms' : 'term';

        return [
            $keyTerms => [
                $this->key => $this->value
            ],
        ];
    }
}