<?php

namespace IQDEV\ElasticSearch\Search\BoolQuery;


use IQDEV\ElasticSearch\Esable;

final class RangeTerms implements Esable
{
    private string $key;

    private float $min;
    private float $max;

    /**
     * @param string $key
     * @param float $min
     * @param float $max
     */
    public function __construct(string $key, float $min, float $max)
    {
        $this->key = $key;
        $this->min = $min;
        $this->max = $max;
    }

    public function es(): array
    {
        return [
            'range' => [
                $this->key => [
                    'gte' => $this->min,
                    'lte' => $this->max
                ]
            ]
        ];
    }
}