<?php

namespace IQDEV\ElasticSearch\Search\BoolQuery;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Search\Nested;


final class Query implements Esable
{
    protected BoolQueryCollection $must;
    protected BoolQueryCollection $filter;
    protected BoolQueryCollection $should;
    protected BoolQueryCollection $mustNot;
    
    protected string $type;
    
    public const TYPE_QUERY = 'query';
    public const TYPE_FILTER = 'filter';

    public function __construct()
    {
        $this->must = new BoolQueryCollection();
        $this->filter = new BoolQueryCollection();
        $this->should = new BoolQueryCollection();
        $this->mustNot = new BoolQueryCollection();
        $this->type = self::TYPE_QUERY;
    }

    /**
     * @param Terms|Nested $item
     * @return $this
     */
    public function must($item): self
    {
        $this->must->add($item);
        return $this;
    }

    public function filter(Esable $item): self
    {
        $this->filter->add($item);
        return $this;
    }

    public function should(Esable $item): self
    {
        $this->should->add($item);
        return $this;
    }

    public function mustNot(Esable $item): self
    {
        $this->mustNot->add($item);
        return $this;
    }

    public function isEmpty(): bool
    {
        return $this->must->isEmpty()
            && $this->mustNot->isEmpty()
            && $this->filter->isEmpty()
            && $this->should->isEmpty();
    }
    
    public function setType(string $type): self
    {
        switch($type) {
            case self::TYPE_FILTER:
            case self::TYPE_QUERY:
                $this->type = $type;
                break;
            default:
                break;
        }
        return $this;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function es(): array
    {
        $bool = [];
        if ($this->filter->isEmpty() === false) {
            $bool['filter'] = $this->filter->es();
        }

        if ($this->must->isEmpty() === false) {
            $bool['must'] = $this->must->es();
        }

        if ($this->mustNot->isEmpty() === false) {
            $bool['must_not'] = $this->mustNot->es();
        }

        if ($this->should->isEmpty() === false) {
            $bool['should'] = $this->should->es();
        }

        return [
            $this->type => [
                'bool' => $bool,
            ]
        ];
    }
}