<?php

namespace IQDEV\ElasticSearch\Search\BoolQuery;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Search\Nested;


final class FilterNumberFacet implements Esable
{
    public string $key;

    public float $min = 0;
    public float $max = PHP_INT_MAX;

    public function __construct(string $key, float $min, float $max)
    {
        $this->key   = $key;
        $this->min = $min;
        $this->max = $max;
    }

    public function es(): array
    {
        $path = 'search_data.number_facet';

        $nested = new Nested();

        $query = new Query();
        $query
            ->filter(new Terms($path . '.facet_code', $this->key))
            ->filter(new RangeTerms($path . '.facet_value', $this->min, $this->max));

        $nested
            ->setPath($path)
            ->setQuery($query);

        return $nested->es();
    }
}