<?php

namespace IQDEV\ElasticSearch\Search\Aggs;


use IQDEV\ElasticSearch\Esable;

final class ExtremumTerms implements Esable
{
    private string $sOperation;
    private string $field;

    /**
     * @param string $field
     */
    public function __construct(string $field)
    {
        $this->field = $field;
    }

    public function setOperation($sOperation): self
    {
        $this->sOperation = $sOperation;
        return $this;
    }

    public function es(): array
    {
        $data = [
            'field' => $this->field
        ];

        return [$this->sOperation => $data];
    }
}