<?php

namespace IQDEV\ElasticSearch\Search\Aggs;

use IQDEV\ElasticSearch\Search\Nested;

final class AggsNumberFacet
{
    public static function create(string $code, string $facet, string $path = 'search_data'): Aggs
    {
        $aggFacet = new Aggs($code);
        $nested   = new Nested();
        $nested->setPath($path . '.' . $facet);
        $aggFacet->setNested($nested);

        $aggFacetCode = new Aggs("agg_{$facet}_code");
        $aggFacetCode->setTerms(
            (new Terms("{$path}.{$facet}.facet_code"))
        );

        $aggFacetValue = new Aggs("agg_{$facet}_min_value");
        $aggFacetValue->setExtremumTerms(
            (new ExtremumTerms("{$path}.{$facet}.facet_value"))
            ->setOperation('min')
        );
        $aggFacetCode->addAggs($aggFacetValue);

        $aggFacetValue = new Aggs("agg_{$facet}_max_value");
        $aggFacetValue->setExtremumTerms(
            (new ExtremumTerms("{$path}.{$facet}.facet_value"))
                ->setOperation('max')
        );
        $aggFacetCode->addAggs($aggFacetValue);

        $aggFacet->addAggs($aggFacetCode);

        return $aggFacet;
    }
}
