<?php

namespace IQDEV\ElasticSearch\Search\Aggs;

use IQDEV\ElasticSearch\Esable;
use Ramsey\Collection\AbstractCollection;

final class AggsCollection extends AbstractCollection implements Esable
{
    public function getType(): string
    {
        return Aggs::class;
    }

    public function es(): array
    {
        $aggs = [];
        foreach ($this as $agg) {
            $aggs[$agg->getKey()] = $agg->es();
        }

        return ['aggs' => $aggs];
    }
}