<?php

namespace IQDEV\ElasticSearch\Facet;

use IQDEV\ElasticSearch\Facet\Item\FacetItemCollection;

class FacetResult
{
    public FacetItemCollection $products;

    protected FacetType $type;

    protected string $code;

    public function __construct(FacetType $type, string $code)
    {
        $this->type = $type;
        $this->code = $code;
        $this->products = new FacetItemCollection();
    }

    public function getType(): FacetType
    {
        return $this->type;
    }

    public function getCode(): string
    {
        return $this->code;
    }
}
