<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Converter\Request\Filter;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Criteria\Filter\Collection\FilterGroupCollection;
use IQDEV\ElasticSearch\Criteria\Filter\LogicOperator;
use IQDEV\ElasticSearch\Search\BoolQuery\Query;
use IQDEV\ElasticSearch\Search\Nested;

abstract class AbstractFilterQuery
{
    protected Query $query;

    public function __construct() {
        $this->query = new Query();
    }

    protected function setFilterByLogic(Query $query, LogicOperator $logicOperator, Esable $filter): void
    {
        match ($logicOperator) {
            LogicOperator::AND => $query->getFilter()->add($filter),
            LogicOperator::OR => $query->getShould()->add($filter),
            LogicOperator::NOT => $query->getMustNot()->add($filter),
        };
    }

    abstract public function getQuery(FilterGroupCollection $filterGroupCollection, array $exclude): Query|Nested;
}
