<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Converter\Request\Aggregation;

use IQDEV\ElasticSearch\Configuration;
use IQDEV\ElasticSearch\Criteria\Criteria;
use IQDEV\ElasticSearch\Criteria\Filter\FilterType;
use IQDEV\ElasticSearch\Search\Aggs\AggsCollection;
use IQDEV\ElasticSearch\Search\Aggs\AggsFacetStats;
use IQDEV\ElasticSearch\Search\Aggs\AggsFacetTerms;

class Aggregation
{
    public function __construct(
        private readonly Configuration $configuration,
        private readonly Criteria $criteria,
        private readonly AggsCollection $aggregations = new AggsCollection(),
    ) {
        $this->convertToQuery();
    }

    public function convertToQuery(): void
    {
        $queryFilterCollection = $this->criteria->getFilters()->getFilterCollectionByType(FilterType::QUERY);

        if (false === $this->criteria->getSearch()->isEmpty() || false === $this->criteria->getFilters()->isEmpty()) {

            $this->aggregations->add(
                AggsFacetTerms::create(
                    'keyword_facet', 'keyword_facet'
                )
            );

            $this->aggregations->add(
                AggsFacetStats::create(
                    'number_facet', 'number_facet'
                )
            );

            $filterAggregation = new FilterAggregation($this->configuration, $queryFilterCollection);
            $filterAggregation->updateRequestAggregation($this->aggregations);

            $fullAggregation = new FullAggregation($this->configuration, $queryFilterCollection);
            $fullAggregation->updateRequestAggregation($this->aggregations);
        }

        if (false === $this->criteria->getAggs()->isEmpty()) {
            $propertyAggregation = new PropertyAggregation(
                $this->configuration,
                $queryFilterCollection,
                $this->criteria->getAggs(),
            );
            $propertyAggregation->updateRequestAggregation($this->aggregations);
        }
    }

    public function getAggregation(): AggsCollection
    {
        return $this->aggregations;
    }
}
