<?php

namespace IQDEV\ElasticSearchTests\Factory;

use Elastic\Elasticsearch\Client;
use Elastic\Elasticsearch\ClientBuilder;

class ClientFactory
{
    private static $instance = null;

    public static function create(): Client
    {
        if (self::$instance !== null) {
            return self::$instance;
        }

        self::$instance = ClientBuilder::create()
            ->setHosts(explode(',', $_ENV['IQ_ES_HOSTS'] ?: 'http://localhost:9200'))
            ->setBasicAuthentication($_ENV['IQ_ES_USER'], $_ENV['IQ_ES_PASSWORD'])
            ->build();

        return self::$instance;
    }
}