<?php

namespace IQDEV\ElasticSearch\Search\Aggs;

use IQDEV\ElasticSearch\Search\Nested;

final class AggsFacetStats
{
    public static function create(string $code, string $facet, string $path = 'search_data'): Aggs
    {
        $aggNumberFacet = new Aggs($code);
        $nested = new Nested();
        $nested->setPath($path . '.' . $facet);
        $aggNumberFacet->setNested($nested);

        $aggNumberFacetCode = new Aggs("agg_{$facet}_code");
        $aggNumberFacetCode->setTerms(
            (new Terms("{$path}.{$facet}.facet_code"))
                ->setSize(250)
        );
        $aggKeywordFacetValue = new Aggs("agg_{$facet}_value");
        $aggKeywordFacetValue->setStats(
            new Stats("{$path}.{$facet}.facet_value")
        );

        $aggNumberFacetCode->addAggs($aggKeywordFacetValue);
        $aggNumberFacet->addAggs($aggNumberFacetCode);

        return $aggNumberFacet;
    }
}
