<?php

namespace IQDEV\ElasticSearch\Search;

use IQDEV\ElasticSearch\Esable;

class Pagination implements Esable
{
    private ?int $size;
    private ?int $from;

    public function __construct(?int $size = null, ?int $from = null)
    {
        $this->size = $size;
        $this->from = $from;
    }

    public function es(): array
    {
        $pagination = [];

        if ($this->from) {
            $pagination['from'] = $this->from;
        }

        if ($this->size) {
            $pagination['size'] = $this->size;
        }

        return $pagination;
    }
}
